//=============================================================================
// Duck Yea.
//=============================================================================
class CustomRifle extends DeusExWeapon;

var Mesh LoadHax[3];

#exec TEXTURE IMPORT FILE="Textures\AKBlack.pcx"	NAME="AKBlack"	GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\AKGray90.pcx"	NAME="AKGray90"	GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\AKGray80.pcx"	NAME="AKGray80"	GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\AKGray70.pcx"	NAME="AKGray70"	GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\AKGray60.pcx"	NAME="AKGray60"	GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\AKGray55.pcx"	NAME="AKGray55"	GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\AKGray50.pcx"	NAME="AKGray50"	GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\AKGray40.pcx"	NAME="AKGray40"	GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\AKBrown.pcx"	NAME="AKBrown"	GROUP="Skins" MIPS=Off

//==================
//AK47PickupMag
//==================
#exec MESH IMPORT MESH=AK47PickupMag ANIVFILE=MODELS\AK47PickupMag_a.3d DATAFILE=MODELS\AK47PickupMag_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK47PickupMag X=0 Y=0 Z=0 PITCH=0 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=AK47PickupMag SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK47PickupMag SEQ=AK47PickupMag STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=AK47PickupMag MESH=AK47PickupMag
#exec MESHMAP SCALE MESHMAP=AK47PickupMag X=0.0114472413 Y=-0.0114472413 Z=0.0114472413

#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupMag NUM=0 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupMag NUM=1 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupMag NUM=4 TEXTURE=AKGray60
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupMag NUM=5 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupMag NUM=6 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupMag NUM=7 TEXTURE=AKGray55
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupMag NUM=8 TEXTURE=AKBlack

//==================
//AK47PickupDrum
//==================
#exec MESH IMPORT MESH=AK47PickupDrum ANIVFILE=MODELS\AK47PickupDrum_a.3d DATAFILE=MODELS\AK47PickupDrum_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK47PickupDrum X=0 Y=0 Z=0 PITCH=0 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=AK47PickupDrum SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK47PickupDrum SEQ=AK47PickupDrum STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=AK47PickupDrum MESH=AK47PickupDrum
#exec MESHMAP SCALE MESHMAP=AK47PickupDrum X=0.0114472413 Y=-0.0114472413 Z=0.0114472413

#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupDrum NUM=0 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupDrum NUM=1 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupDrum NUM=4 TEXTURE=AKGray60
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupDrum NUM=5 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupDrum NUM=6 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupDrum NUM=7 TEXTURE=AKGray55
#exec MESHMAP SETTEXTURE MESHMAP=AK47PickupDrum NUM=8 TEXTURE=AKBlack

//==================
//AK473rdDrum
//==================
#exec MESH IMPORT MESH=AK473rdDrum ANIVFILE=MODELS\AK473rdDrum_a.3d DATAFILE=MODELS\AK473rdDrum_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK473rdDrum X=0 Y=0 Z=0 PITCH=26 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=AK473rdDrum SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK473rdDrum SEQ=AK473rdDrum STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=AK473rdDrum MESH=AK473rdDrum
#exec MESHMAP SCALE MESHMAP=AK473rdDrum X=0.0114472413 Y=-0.0114472413 Z=0.0114472413

#exec MESHMAP SETTEXTURE MESHMAP=AK473rdDrum NUM=0 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdDrum NUM=1 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdDrum NUM=4 TEXTURE=AKGray60
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdDrum NUM=5 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdDrum NUM=6 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdDrum NUM=7 TEXTURE=AKGray55
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdDrum NUM=8 TEXTURE=AKBlack

//==================
//AK473rdMag
//==================
#exec MESH IMPORT MESH=AK473rdMag ANIVFILE=MODELS\AK473rdMag_a.3d DATAFILE=MODELS\AK473rdMag_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK473rdMag X=0 Y=0 Z=0 PITCH=26 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=AK473rdMag SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK473rdMag SEQ=AK473rdMag STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=AK473rdMag MESH=AK473rdMag
#exec MESHMAP SCALE MESHMAP=AK473rdMag X=0.0114472413 Y=-0.0114472413 Z=0.0114472413

#exec MESHMAP SETTEXTURE MESHMAP=AK473rdMag NUM=0 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdMag NUM=1 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdMag NUM=4 TEXTURE=AKGray60
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdMag NUM=5 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdMag NUM=6 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdMag NUM=7 TEXTURE=AKGray55
#exec MESHMAP SETTEXTURE MESHMAP=AK473rdMag NUM=8 TEXTURE=AKBlack

//==================
//AK471stMag
//==================
#exec TEXTURE IMPORT NAME=CustomRifleMuz FILE=Textures\CusMuz.PCX GROUP=Skins // Yellow


#exec MESH IMPORT MESH=AK471stMag ANIVFILE=MODELS\AK471stMag_a.3d DATAFILE=MODELS\AK471stMag_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK471stMag X=0 Y=0 Z=0 PITCH=0 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=AK471stMag SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK471stMag SEQ=AK471stMag STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK471stMag SEQ=Select STARTFRAME=0 NUMFRAMES=4 RATE=8 GROUP=Select
//VVV#exec MESH SEQUENCE MESH=AK471stMag SEQ=Down		STARTFRAME=4	NUMFRAMES=4		RATE=8
//**#exec MESH SEQUENCE MESH=AK471stMag SEQ=Shoot		STARTFRAME=8	NUMFRAMES=4		RATE=4
//VVV#exec MESH SEQUENCE MESH=AK471stMag SEQ=ReloadBegin	STARTFRAME=12	NUMFRAMES=7		RATE=7
//**#exec MESH SEQUENCE MESH=AK471stMag SEQ=Reload		STARTFRAME=19	NUMFRAMES=2		RATE=2.4
//VVV#exec MESH SEQUENCE MESH=AK471stMag SEQ=ReloadEnd	STARTFRAME=21	NUMFRAMES=7		RATE=7
//**#exec MESH SEQUENCE MESH=AK471stMag SEQ=Toggle		STARTFRAME=28	NUMFRAMES=3		RATE=12
//#exec MESH SEQUENCE MESH=AK471stMag SEQ=Idle1		STARTFRAME=4	NUMFRAMES=1		RATE=2
//#exec MESH SEQUENCE MESH=AK471stMag SEQ=Idle2		STARTFRAME=4	NUMFRAMES=1		RATE=2
//#exec MESH SEQUENCE MESH=AK471stMag SEQ=Idle3		STARTFRAME=4	NUMFRAMES=1	RATE=2
//#exec MESH SEQUENCE MESH=AK471stMag SEQ=Still		STARTFRAME=4	NUMFRAMES=1	RATE=2

#exec MESHMAP NEW   MESHMAP=AK471stMag MESH=AK471stMag
#exec MESHMAP SCALE MESHMAP=AK471stMag X=0.0114472413 Y=-0.0114472413 Z=0.0114472413

#exec MESHMAP SETTEXTURE MESHMAP=AK471stMag NUM=0 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK471stMag NUM=1 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK471stMag NUM=2 TEXTURE=AKGray90
#exec MESHMAP SETTEXTURE MESHMAP=AK471stMag NUM=3 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=AK471stMag NUM=4 TEXTURE=AKGray60
#exec MESHMAP SETTEXTURE MESHMAP=AK471stMag NUM=5 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK471stMag NUM=6 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK471stMag NUM=7 TEXTURE=AKGray55
#exec MESHMAP SETTEXTURE MESHMAP=AK471stMag NUM=8 TEXTURE=AKBlack

//==================
//AK471stDrum
//==================
#exec TEXTURE IMPORT NAME=CustomRifleMuz FILE=Textures\CusMuz.PCX GROUP=Skins // Yellow


#exec MESH IMPORT MESH=AK471stDrum ANIVFILE=MODELS\AK471stDrum_a.3d DATAFILE=MODELS\AK471stDrum_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AK471stDrum X=0 Y=0 Z=0 PITCH=0 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=AK471stDrum SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=AK471stDrum STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=Select STARTFRAME=0 NUMFRAMES=4 RATE=8 GROUP=Select
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=Down		STARTFRAME=4	NUMFRAMES=4		RATE=8
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=Shoot		STARTFRAME=8	NUMFRAMES=4		RATE=4
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=ReloadBegin	STARTFRAME=12	NUMFRAMES=7		RATE=7
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=Reload		STARTFRAME=19	NUMFRAMES=2		RATE=2.4
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=ReloadEnd	STARTFRAME=21	NUMFRAMES=7		RATE=7
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=Toggle		STARTFRAME=28	NUMFRAMES=3		RATE=4.5
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=Idle1		STARTFRAME=4	NUMFRAMES=1		RATE=2
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=Idle2		STARTFRAME=4	NUMFRAMES=1		RATE=2
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=Idle3		STARTFRAME=4	NUMFRAMES=1	RATE=2
#exec MESH SEQUENCE MESH=AK471stDrum SEQ=Still		STARTFRAME=4	NUMFRAMES=1	RATE=2

#exec MESHMAP NEW   MESHMAP=AK471stDrum MESH=AK471stDrum
#exec MESHMAP SCALE MESHMAP=AK471stDrum X=0.0114472413 Y=-0.0114472413 Z=0.0114472413

#exec MESHMAP SETTEXTURE MESHMAP=AK471stDrum NUM=0 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK471stDrum NUM=1 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK471stDrum NUM=2 TEXTURE=AKGray90
#exec MESHMAP SETTEXTURE MESHMAP=AK471stDrum NUM=3 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=AK471stDrum NUM=4 TEXTURE=AKGray60
#exec MESHMAP SETTEXTURE MESHMAP=AK471stDrum NUM=5 TEXTURE=AKBrown
#exec MESHMAP SETTEXTURE MESHMAP=AK471stDrum NUM=6 TEXTURE=AKGray70
#exec MESHMAP SETTEXTURE MESHMAP=AK471stDrum NUM=7 TEXTURE=AKGray55
#exec MESHMAP SETTEXTURE MESHMAP=AK471stDrum NUM=8 TEXTURE=AKBlack


var travel string CustomName, CustomColor;

//stats
var travel int AccMod, ClipMod, WeightMod, DamageMod, RecoilMod, 
    CaliberType;

var travel float RateMod, ReloadMod;

var travel int PinDurability, CurPinDurability; //firing pin
var travel int BarrelDurability, CurBarrelDurability; // barrel
var travel int StockDurability, CurStockDurability; //stock
var travel int BodyDurability, CurBodyDurability; //body
var travel int FeedDurability, CurFeedDurability; //feed system

var travel int AccesoryDurability, CurAccesoryDurability;

var travel string FeedName, PinName, BarrelName, StockName, BodyName, AccesoryName;
var travel bool bHasStock, bHasFeed;



var travel int BurstFireCount, CurBurstFireCount;

var travel bool bBurstFire, bSemiAutomatic;

var travel bool bTraceProj;

var sound CustomFireSound, AfterFireSound, Reload1Sound, Reload2Sound, SilencedFireSound;
var travel string CusFire, AftFire, Reload1, Reload2, SilenFire, CusSelect;

var travel string Multi0, Multi1, Multi4, Multi5, Multi6;
var travel string PickupMesh, ThirdMesh, FirstMesh;

var travel bool bHasBurst, bHasAuto;
var travel bool bUsingSilencer;

var travel string Accesory;
var bool bTweakSkins;

var bool bUsingScope;

var Travel bool bHasFlashlight, bHasCustomFlashlight;
var float FlashCounter;

var FlashBeam b1, b2;


#exec OBJ LOAD FILE=MSBorderFX


//-------------
//Sounds
//-------------

//Firing
#exec AUDIO IMPORT FILE="Sounds\RiflePop.wav" NAME="RifleFire1" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\Carbine2Fire.wav" NAME="RifleFire2" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\RevolverFire.wav" NAME="RifleFire3" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\Saiga12Fire.wav" NAME="RifleFire4" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\BarrettFire.wav" NAME="BarrettFire" GROUP="Weapons"

//Silenced Firing
#exec AUDIO IMPORT FILE="Sounds\SilencedRifleFire.wav" NAME="SilencedRifleFire" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\RiflePopSilenced.wav" NAME="SilencedRifleFire1" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\Carbine2FireSilenced.wav" NAME="SilencedRifleFire2" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\RevolverFireSilenced.wav" NAME="SilencedRifleFire3" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\Saiga12FireSilenced.wav" NAME="SilencedRifleFire4" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\BarrettFireSilenced.wav" NAME="BarrettFireSilenced" GROUP="Weapons"


//Misc/Function Called
#exec AUDIO IMPORT FILE="Sounds\ComponentShatter.wav" NAME="PartShatter" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\WeaponJam.wav" NAME="WeaponJam" GROUP="Weapons"

#exec AUDIO IMPORT FILE="Sounds\ModeFlick1.wav" NAME="WeaponFlick1" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\ModeFlick2.wav" NAME="WeaponFlick2" GROUP="Weapons"

//Reloading
#exec AUDIO IMPORT FILE="Sounds\M249Reload.wav" NAME="DrumReload" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\M249ReloadEnd.wav" NAME="DrumReloadEnd" GROUP="Weapons"

#exec AUDIO IMPORT FILE="Sounds\M203LoadStart.wav" NAME="M203Reload" GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\M203LoadEnd.wav" NAME="M203ReloadEnd" GROUP="Weapons"

function LaserOn()
{
	if (!bHasFlashlight && !bHasCustomFlashlight) Super.LaserOn();

	if (bHasLaser && bHasFlashlight && !bLasing)
	{
		bLasing = True;

		PlaySound(sound'AugActivate');
		Pawn(Owner).ClientMessage("Flashlight Activated");

		b1 = Spawn(class'FlashBeam', Self, '', DeusExPlayer(Owner).Location);
		if (b1 != None)
		{
			AIStartEvent('Beam', EAITYPE_Visual);
			b1.LightHue = 32;
			b1.LightRadius = 4;
			b1.LightSaturation = 140;
			b1.LightBrightness = 192;

			SetBeamLocation();
		}
		b2 = Spawn(class'FlashBeam', Self, '', DeusExPlayer(Owner).Location);
		if (b2 != None)
		{
			b2.LightHue = 32;
			b2.LightRadius = 4;
			b2.LightSaturation = 140;
			b2.LightBrightness = 220;

			SetGlowLocation();
		}
	}
}

function LaserOff()
{
	if (bHasLaser && bLasing && bHasFlashlight)
	{
		if (b1 != None)
			b1.Destroy();
		if (b2 != None)
			b2.Destroy();
		b1 = None;
		b2 = None;

		PlaySound(sound'AugDeactivate');

		Pawn(Owner).ClientMessage("Flashlight Deactivated.");

		bLasing = False;
	}


	Super.LaserOff();

	bHasLaser = False;
	bHasFlashlight = False;
	bHasCustomFlashlight = False;
}


simulated function Tick(float deltaTime)
{
	local vector loc;
	local rotator rot;
	local float beepspeed, recoil;
	local DeusExPlayer player;
   local Actor RealTarget;
	local Pawn pawn;

	player = DeusExPlayer(Owner);
	pawn = Pawn(Owner);

	Super(Weapon).Tick(deltaTime);

	FlashCounter += deltaTime;

	if (int(FlashCounter) > 0)
	{
	 if (bLasing && bHasFlashlight && Accesory ~= "TacticalFlashlight")
	 {
	  CurAccesoryDurability -= FlashCounter;
	  if (CurAccesoryDurability <= 0)
	  {
	   PlayBreakSound();
	   LaserOff();
	   Pawn(Owner).ClientMessage("|cf88000Flashlight depleted.");
	   Accesory = "";
	   AccesoryName = "";
	   bHasLaser = False;
	   bHasFlashlight = False;
	   bHasCustomFlashlight = False;
	  }
	 }
	 FlashCounter = 0;
	}

	// don't do any of this if this weapon isn't currently in use
	if (pawn == None)
   {
      LockMode = LOCK_None;
      MaintainLockTimer = 0;
      LockTarget = None;
      LockTimer = 0;
		return;
   }

	if (pawn.Weapon != self)
   {
      LockMode = LOCK_None;
      MaintainLockTimer = 0;
      LockTarget = None;
      LockTimer = 0;
		return;
   }

	// all this should only happen IF you have ammo loaded
	if (ClipCount < ReloadCount)
	{
		// check for LAM or other placed mine placement
		if (bHandToHand && (ProjectileClass != None) && (!Self.IsA('WeaponShuriken')))
		{
			if (NearWallCheck())
			{
				if (( Level.NetMode != NM_Standalone ) && IsAnimating() && (AnimSequence == 'Select'))
				{
				}
				else
				{
					if (!bNearWall || (AnimSequence == 'Select'))
					{
						PlayAnim('PlaceBegin',, 0.1);
						bNearWall = True;
					}
				}
			}
			else
			{
				if (bNearWall)
				{
					PlayAnim('PlaceEnd',, 0.1);
					bNearWall = False;
				}
			}
		}


      SoundTimer += deltaTime;

      if ( (Level.Netmode == NM_Standalone) || ( (Player != None) && (Player.PlayerIsClient()) ) )
      {
         if (bCanTrack)
         {
            Target = AcquireTarget();
            RealTarget = Target;
            
            // calculate the range
            if (Target != None)
               TargetRange = Abs(VSize(Target.Location - Location));
            
            // update our timers
            //SoundTimer += deltaTime;
            MaintainLockTimer -= deltaTime;
            
            // check target and range info to see what our mode is
            if ((Target == None) || IsInState('Reload'))
            {
               if (MaintainLockTimer <= 0)
               {				
                  SetLockMode(LOCK_None);
                  MaintainLockTimer = 0;
                  LockTarget = None;
               }
               else if (LockMode == LOCK_Locked)
               {
                  Target = LockTarget;
               }
            }
            else if ((Target != LockTarget) && (Target.IsA('Pawn')) && (LockMode == LOCK_Locked))
            {
               SetLockMode(LOCK_None);
               LockTarget = None;
            }
            else if (!Target.IsA('Pawn'))
            {
               if (MaintainLockTimer <=0 )
               {
                  SetLockMode(LOCK_Invalid);
               }
            }
            else if ( (Target.IsA('DeusExPlayer')) && (Target.Style == STY_Translucent) )
            {
               //DEUS_EX AMSD Don't allow locks on cloaked targets.
               SetLockMode(LOCK_Invalid);
            }
            else if ( (Target.IsA('DeusExPlayer')) && (Player.DXGame.IsA('TeamDMGame')) && (TeamDMGame(Player.DXGame).ArePlayersAllied(Player,DeusExPlayer(Target))) )
            {
               //DEUS_EX AMSD Don't allow locks on allies.
               SetLockMode(LOCK_Invalid);
            }
            else
            {
               if (TargetRange > MaxRange)
               {
                  SetLockMode(LOCK_Range);
               }
               else
               {
                  // change LockTime based on skill
                  // -0.7 = max skill
                  // DEUS_EX AMSD Only do weaponskill check here when first checking.
                  if (LockTimer == 0)
                  {
                     LockTime = FMax(Default.LockTime + 3.0 * GetWeaponSkill(), 0.0);
                     if ((Level.Netmode != NM_Standalone) && (LockTime < 0.25))
                        LockTime = 0.25;
                  }
                  
                  LockTimer += deltaTime;
                  if (LockTimer >= LockTime)
                  {
                     SetLockMode(LOCK_Locked);
                  }
                  else
                  {
                     SetLockMode(LOCK_Acquire);
                  }
               }
            }
            
            // act on the lock mode
            switch (LockMode)
            {
            case LOCK_None:
               TargetMessage = msgNone;
               LockTimer -= deltaTime;
               break;
               
            case LOCK_Invalid:
               TargetMessage = msgLockInvalid;
               LockTimer -= deltaTime;
               break;
               
            case LOCK_Range:
               TargetMessage = msgLockRange @ Int(TargetRange/16) @ msgRangeUnit;
               LockTimer -= deltaTime;
               break;
               
            case LOCK_Acquire:
               TargetMessage = msgLockAcquire @ Left(String(LockTime-LockTimer), 4) @ msgTimeUnit;
               beepspeed = FClamp((LockTime - LockTimer) / Default.LockTime, 0.2, 1.0);
               if (SoundTimer > beepspeed)
               {
                  Owner.PlaySound(TrackingSound, SLOT_None);
                  SoundTimer = 0;
               }
               break;
               
            case LOCK_Locked:
               // If maintaining a lock, or getting a new one, increment maintainlocktimer
               if ((RealTarget != None) && ((RealTarget == LockTarget) || (LockTarget == None)))
               {
                  if (Level.NetMode != NM_Standalone)
                     MaintainLockTimer = default.MaintainLockTimer;
                  else
                     MaintainLockTimer = 0;
                  LockTarget = Target;
               }
               TargetMessage = msgLockLocked @ Int(TargetRange/16) @ msgRangeUnit;
               // DEUS_EX AMSD Moved out so server can play it so that client knows for sure when locked.
               /*if (SoundTimer > 0.1)
               {
                  Owner.PlaySound(LockedSound, SLOT_None);
                  SoundTimer = 0;
               }*/
               break;
            }
         }
         else
         {
            LockMode = LOCK_None;
            TargetMessage = msgNone;
            LockTimer = 0;
            MaintainLockTimer = 0;
            LockTarget = None;
         }
         
         if (LockTimer < 0)
            LockTimer = 0;
      }
   }
   else
   {
      LockMode = LOCK_None;
	  TargetMessage=msgNone;
      MaintainLockTimer = 0;
      LockTarget = None;
      LockTimer = 0;
   }

   if ((LockMode == LOCK_Locked) && (SoundTimer > 0.1) && (Role == ROLE_Authority))
   {
      PlayLockSound();
      SoundTimer = 0;
   }

	currentAccuracy = CalculateAccuracy();

	if (player != None)
	{
		// reduce the recoil based on skill
		recoil = recoilStrength + GetWeaponSkill() * 2.0;
		if (recoil < 0.0)
			recoil = 0.0;

		// simulate recoil while firing
		if (bFiring && IsAnimating() && (AnimSequence == 'Shoot') && (recoil > 0.0))
		{
			player.ViewRotation.Yaw += deltaTime * (Rand(4096) - 2048) * recoil;
			player.ViewRotation.Pitch += deltaTime * (Rand(4096) + 4096) * recoil;
			if ((player.ViewRotation.Pitch > 16384) && (player.ViewRotation.Pitch < 32768))
				player.ViewRotation.Pitch = 16384;
		}
	}

	// if were standing still, increase the timer
	if (VSize(Owner.Velocity) < 10)
		standingTimer += deltaTime;
	else	// otherwise, decrease it slowly based on velocity
		standingTimer = FMax(0, standingTimer - 0.03*deltaTime*VSize(Owner.Velocity));

	if (bLasing || bZoomed)
	{
		// shake our view to simulate poor aiming
		if (ShakeTimer > 0.25)
		{
			ShakeYaw = currentAccuracy * (Rand(4096) - 2048);
			ShakePitch = currentAccuracy * (Rand(4096) - 2048);
			ShakeTimer -= 0.25;
		}

		ShakeTimer += deltaTime;

		if (bLasing && bHasFlashlight)
		{
			 SetBeamLocation();
			 SetGlowLocation();

			if (bHasCustomFlashlight) UpdateBeamColor();
		}

		if (bLasing && (Emitter != None))
		{
			loc = Owner.Location;
			loc.Z += Pawn(Owner).BaseEyeHeight;

			// add a little random jitter - looks cool!
			rot = Pawn(Owner).ViewRotation;
			rot.Yaw += Rand(5) - 2;
			rot.Pitch += Rand(5) - 2;

			Emitter.SetLocation(loc);
			Emitter.SetRotation(rot);
		}

		if ((player != None) && bZoomed)
		{
			player.ViewRotation.Yaw += deltaTime * ShakeYaw;
			player.ViewRotation.Pitch += deltaTime * ShakePitch;
		}
	}
}

function SetBeamLocation()
{
	local float dist, size, radius, brightness;
	local Vector HitNormal, HitLocation, StartTrace, EndTrace;

	if (b1 != None)
	{
		StartTrace = DeusExPlayer(Owner).Location;
		StartTrace.Z += DeusExPlayer(Owner).BaseEyeHeight;
		EndTrace = StartTrace + 768 * Vector(DeusExPlayer(Owner).ViewRotation);

		Trace(HitLocation, HitNormal, EndTrace, StartTrace, True);
		if (HitLocation == vect(0,0,0))
			HitLocation = EndTrace;

		dist       = VSize(HitLocation - StartTrace);
		size       = fclamp(dist/768, 0, 1);
		radius     = size*5.12 + 4.0;
		brightness = fclamp(size-0.5, 0, 1)*2*-192 + 192;
		b1.SetLocation(HitLocation-vector(DeusExPlayer(Owner).ViewRotation)*64);
		b1.LightRadius     = byte(radius);
		//b1.LightBrightness = byte(brightness);  // someday we should put this back in again
		b1.LightType       = LT_Steady;
	}
}

function vector SetGlowLocation()
{
	local vector pos;

	if (b2 != None)
	{
		pos = DeusExPlayer(Owner).Location + vect(0,0,1)*DeusExPlayer(Owner).BaseEyeHeight +
		      vect(1,1,0)*vector(DeusExPlayer(Owner).Rotation)*DeusExPlayer(Owner).CollisionRadius*1.5;
		b2.SetLocation(pos);
	}
}


function UpdateBeamColor()
{
	local byte TempSat, TempHue;

	if (InStr(ItemName, "|cffffff") > -1)
	{
	 TempSat = 0;
	 tempHue = 160;
	}
	if (InStr(ItemName, "|ce5e500") > -1)
	{
	 TempSat = 240;
	 tempHue = 38;
	}
	if (InStr(ItemName, "|c20a748") > -1)
	{
	 TempSat = 163;
	 tempHue = 92;
	}
	if (InStr(ItemName, "|c0099db") > -1)
	{
	 TempSat = 240;
	 tempHue = 132;
	}
	if (InStr(ItemName, "|cdf1b22") > -1)
	{
	 TempSat = 205;
	 tempHue = 238;
	}
	if (InStr(ItemName, "|cff7825") > -1)
	{
	 TempSat = 240;
	 tempHue = 16;
	}
	if (InStr(ItemName, "|c9a459b") > -1)
	{
	 TempSat = 92;
	 tempHue = 200;
	}
	

	b1.LightHue = TempHue;
        b2.LightHue = TempHue;
        b1.LightSaturation = TempSat;
        b2.LightSaturation = TempSat;
}

function AltFire(float f)
{
 LaserToggle();
}

simulated function SwapMuzzleFlashTexture()
{
   /*if (!bHasMuzzleFlash)
      return;*/
		MultiSkins[3] = Texture'CustomRifleMuz';

	MuzzleFlashLight();
	SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
	MultiSkins[3] = Texture'BlackMaskTex';
}




function ResetAccesory()
{
 if (bZoomed) ScopeOff();
 if (bLasing) LaserOff();
 if (AmmoName == class'Ammo20mm') CycleAmmo();
 if (bUsingSilencer) bUsingSilencer = False;
}

function GetValidAccesoryClasses(out class<CraftingAccesory> A, out class<CraftingAccesory> B, out class<CraftingAccesory> C, out class<CraftingAccesory> D, out class<CraftingAccesory> E, out class<CraftingAccesory> F)
{
 A = class'GrenadeLauncher';
 B = class'Silencer';
 C = class'AcogSight';
 D = class'LaserSight';
 E = class'Flashlight';
 F = class'CustomFlashlight';
}

function bool CanHaveAccesory(string Acc)
{
 if (Acc ~= "Silencer") return True;
 if (Acc ~= "GrenadeLauncher") return True;
 if (Acc ~= "Acog") return True;
 if (Acc ~= "LaserSight") return True;
 if (Acc ~= "TacticalFlashlight") return True;
 if (Acc ~= "CustomFlashlight") return True;
 
 return False;
}

function ScopeToggle()
{
 UseAccesory();
}

function String GetAccesoryType()
{
 if (Accesory ~= "Silencer") return "Silencer";
 if (Accesory ~= "GrenadeLauncher") return "Grenade Launcher";
 if (Accesory ~= "Acog") return "Acog Sight";
 if (Accesory ~= "LaserSight") return "Laser Sight";
 if (Accesory ~= "TacticalFlashlight") return "Tactical Flashlight";
 if (Accesory ~= "CustomFlashlight") return "Custom Flashlight";
}

function UseAccesory()
{
 if (Accesory ~= "Silencer")
 {
  bUsingSilencer = !bUsingSilencer;
  
  if (bUsingSilencer)
  {
   bHasSilencer = True;
   Pawn(Owner).ClientMessage("Silencer Attached");
   PlaySwitch1();
  }
  if (!bUsingSilencer)
  {
   bHasSilencer = False;
   Pawn(Owner).ClientMessage("Silencer Removed");
   PlaySwitch2();
  }
 }
 if (Accesory ~= "LaserSight")
 {
  bHasLaser = True;
  Super.LaserToggle();
  return;
 }
 if (Accesory ~= "TacticalFlashlight")
 {
  bHasLaser = True;
  bHasFlashlight = True;
  Super.LaserToggle();
  return;
 }
 if (Accesory ~= "CustomFlashlight")
 {
  bHasLaser = True;
  bHasFlashlight = True;
  bHasCustomFlashlight = True;
  Super.LaserToggle();
  return;
 }
 if (Accesory ~= "Acog")
 {
  if (!bUsingScope)
  {
   ScopeFOV = 25;
   bUsingScope = True;
   bHasScope = True;
   Super.ScopeToggle();
   bHasScope = False;
   PlaySwitch1();
   return;
  }
  if (bUsingScope)
  {
   if (ScopeFOV == 25)
   {
    bHasScope = True;
    Super.ScopeToggle();
    ScopeFOV = 12;
    Super.ScopeToggle();
    bHasScope = False;
    PlaySwitch1();
    return;
   }
   if (ScopeFOV == 12)
   {
    ScopeFOV = 25;
    //bUsingScope = False;
    bHasScope = True;
    Super.ScopeToggle();
    bHasScope = False;
    PlaySwitch2();  
    return;
   }
  }
 }
 if (Accesory ~= "GrenadeLauncher")
 {
  if (AmmoName != Class'Ammo20mm')
  {
   if (DeusExPlayer(Owner).FindInventoryType(class'Ammo20mm') == None) Pawn(Owner).ClientMessage("No 20mm Ammo Available");
   
   Super.CycleAmmo();
   return;
  }
  if (AmmoName == Class'Ammo20mm')
  {
   CycleAmmo();
   return;
  }
 }
}

//=======================================
//Removed bHasScope Req as a bugfix
//=======================================
function ScopeOn()
{
	if (!bZoomed && (Owner != None) && Owner.IsA('DeusExPlayer'))
	{
		// Show the Scope View
		bUsingScope = True;
		bZoomed = True;
		RefreshScopeDisplay(DeusExPlayer(Owner), False, bZoomed);
	}
}

function ScopeOff()
{
	if (bZoomed && (Owner != None) && Owner.IsA('DeusExPlayer'))
	{
		bUsingScope = False;
		bZoomed = False;
		// Hide the Scope View
      RefreshScopeDisplay(DeusExPlayer(Owner), False, bZoomed);
		//DeusExRootWindow(DeusExPlayer(Owner).rootWindow).scopeView.DeactivateView();
	}
}

function bool LoadAmmo(int ammoNum)
{
	local class<Ammo> newAmmoClass;
	local Ammo newAmmo;
	local Pawn P;

	if ((ammoNum < 0) || (ammoNum > 2))
		return False;

	if (DeusExPlayer(Owner).FindInventoryType(class'Ammo20mm') == None)
	{
	 return false;
	}

	P = Pawn(Owner);

	ReloadCount = 1;

	// sorry, only pawns can have weapons
	if (P == None)
		return False;

	newAmmoClass = AmmoNames[ammoNum];

	if (newAmmoClass != None)
	{
		if (newAmmoClass != AmmoName)
		{
			newAmmo = Ammo(P.FindInventoryType(newAmmoClass));
			if (newAmmo == None)
			{
				P.ClientMessage(Sprintf(msgOutOf, newAmmoClass.Default.ItemName));
				return False;
			}
			
			// if we don't have a projectile for this ammo type, then set instant hit
			if (ProjectileNames[ammoNum] == None)
			{
				bInstantHit = True;
				//bAutomatic = Default.bAutomatic;
				//ShotTime = Default.ShotTime;
				if ( Level.NetMode != NM_Standalone )
				{
					if (HasReloadMod())
						ReloadTime = mpReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = mpReloadTime;
				}
				else
				{
					if (HasReloadMod())
						ReloadTime = Default.ReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = Default.ReloadTime;
				}
				FireSound = Default.FireSound;
				ProjectileClass = None;
			}
			else
			{
				// otherwise, set us to fire projectiles
				bInstantHit = False;
				//bAutomatic = False;
				//ShotTime = 1.0;
				if (HasReloadMod())
					ReloadTime = 2.0 * (1.0+ModReloadTime);
				else
					ReloadTime = 2.0;
				FireSound = None;		// handled by the projectile
				ProjectileClass = ProjectileNames[ammoNum];
				ProjectileSpeed = ProjectileClass.Default.Speed;
			}

			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

			// AlexB had a new sound for 20mm but there's no mechanism for playing alternate sounds per ammo type
			// Same for WP rocket
			if ( Ammo20mm(newAmmo) != None )
				FireSound=Sound'AssaultGunFire20mm';
			else if ( AmmoRocketWP(newAmmo) != None )
				FireSound=Sound'GEPGunFireWP';
			else if ( AmmoRocket(newAmmo) != None )
				FireSound=Sound'GEPGunFire';

			if ( Level.NetMode != NM_Standalone )
				SetClientAmmoParams( bInstantHit, bAutomatic, ShotTime, FireSound, ProjectileClass, ProjectileSpeed );

			// Notify the object belt of the new ammo
			if (DeusExPlayer(P) != None)
				DeusExPlayer(P).UpdateBeltText(Self);

			ReloadAmmo();

			P.ClientMessage(Sprintf(msgNowHas, ItemName, newAmmoClass.Default.ItemName));
			return True;
		}
		else
		{
			P.ClientMessage(Sprintf(MsgAlreadyHas, ItemName, newAmmoClass.Default.ItemName));
		}
	}

	return False;
}

function bool DynamicLoadAmmo(Ammo A)
{
	local class<Ammo> newAmmoClass;
	local Ammo newAmmo;
	local Pawn P;

	if (A == None)
		return False;

	newAmmo = A;

	P = Pawn(Owner);

	// sorry, only pawns can have weapons
	if (P == None)
		return False;

	/*newAmmoClass = A.Class;

	if (newAmmoClass != None)
	{
		if (newAmmoClass != AmmoName)
		{
			newAmmo = Ammo(P.FindInventoryType(newAmmoClass));*/
			if (newAmmo == None)
			{
				P.ClientMessage(Sprintf(msgOutOf, newAmmo.ItemName));
				return False;
			}
			
			// if we don't have a projectile for this ammo type, then set instant hit
			/*if (ProjectileNames[ammoNum] == None)
			{
				bInstantHit = True;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if ( Level.NetMode != NM_Standalone )
				{
					if (HasReloadMod())
						ReloadTime = mpReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = mpReloadTime;
				}
				else
				{
					if (HasReloadMod())
						ReloadTime = Default.ReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = Default.ReloadTime;
				}
				FireSound = Default.FireSound;
				ProjectileClass = None;
			}
			else
			{
				// otherwise, set us to fire projectiles
				bInstantHit = False;
				bAutomatic = False;
				ShotTime = 1.0;
				if (HasReloadMod())
					ReloadTime = 2.0 * (1.0+ModReloadTime);
				else
					ReloadTime = 2.0;
				FireSound = None;		// handled by the projectile
				ProjectileClass = ProjectileNames[ammoNum];
				ProjectileSpeed = ProjectileClass.Default.Speed;
			}*/

			AmmoName = newAmmo.Class;
			AmmoType = newAmmo;

			ProjectileClass = None;
			bInstantHit = True;
			ReloadCount = ClipMod;

			// AlexB had a new sound for 20mm but there's no mechanism for playing alternate sounds per ammo type
			// Same for WP rocket
			/*if ( Ammo20mm(newAmmo) != None )
				FireSound=Sound'AssaultGunFire20mm';
			else if ( AmmoRocketWP(newAmmo) != None )
				FireSound=Sound'GEPGunFireWP';
			else if ( AmmoRocket(newAmmo) != None )
				FireSound=Sound'GEPGunFire';*/

			if ( Level.NetMode != NM_Standalone )
				SetClientAmmoParams( bInstantHit, bAutomatic, ShotTime, FireSound, ProjectileClass, ProjectileSpeed );

			// Notify the object belt of the new ammo
			if (DeusExPlayer(P) != None)
				DeusExPlayer(P).UpdateBeltText(Self);

			ReloadAmmo();

			P.ClientMessage(Sprintf(msgNowHas, ItemName, newAmmo.ItemName));
			return True;
		//}
		/*else
		{
			P.ClientMessage(Sprintf(MsgAlreadyHas, ItemName, newAmmoClass.Default.ItemName));
		}
	}*/

	return False;
}

function FixRedundancies()
{
 local AmmoCombatRifle A, Last;
 
 forEach AllActors(class'AmmoCombatRifle', Last)
 {
  if (Last != None)
  {
   forEach AllActors(class'AmmoCombatRifle', A)
   {
    if (A != Last && A.VSBonus ~= Last.VSBonus && A.Special ~= Last.Special && A.Caliber ~= Last.Caliber && A.CustomName ~= Last.CustomName && A.NumProjectiles ~= Last.NumProjectiles && A.AmmoAmount > 0)
    {
     Last.AmmoAmount += A.AmmoAmount;
     A.AmmoAmount = 0;
     A.Destroy();
    }
   }
  }
 }
}

function CycleAmmo()
{
 local AmmoCombatRifle A, Pick, First;
 local bool bNext;
 local int i;
 
  FixRedundancies();
 
 forEach AllActors(class'AmmoCombatRifle', A)
 {
  if (A.Owner == Owner && A.Caliber ~= CaliberType && First == None) First = A;
  
  i++;
  
  if (A.Owner == Owner && bNext && A.Caliber ~= CaliberType && A.AmmoAmount > 0)
  {
   Pick = a;
   break;
  }
  if (A == AmmoType) bNext = True;

  if (A.AmmoAmount <= 0 && A != AmmoType) A.Destroy();
 }
 
 if (AmmoType.AmmoAmount <= 0 && Pick != AmmoType && Pick != None && i > 1) AmmoType.Destroy();
 
 if (Pick == None) Pick = First;
 
 if (Pick != None) hitDamage = Pick.Caliber / 100;
 
 if (AmmoName == class'Ammo20mm' && (Pick == None || Pick == AmmoType))
 {
  AmmoType = None;
  AmmoName = None;
  ReloadCount = ClipMod;
  bInstantHit = True;
  ProjectileClass = None;
 }
 
 if (Pick == AmmoType || Pick == None) Pawn(Owner).ClientMessage(Sprintf(MsgAlreadyHas, ItemName, AmmoType.ItemName));
 if (Pick != AmmoType && Pick != None) DynamicLoadAmmo(Pick);
}

function LaserToggle()
{
 SwitchFiringModes();
}

function SwitchFiringModes()
{
 if (bAutomatic)
 {
  bAutomatic = False;
  
  PlaySwitch2();
  Pawn(Owner).ClientMessage("Fire Set To Semi-Auto");
  bSemiAutomatic = True;
  return;
 }
 
 if (bSemiAutomatic)
 {
  if (bHasBurst)
  {
   bSemiAutomatic = False;
   
   PlaySwitch1();
   Pawn(Owner).ClientMessage("Fire Set To Burst");
   bBurstFire = True;
   return;
  }
  if (bHasAuto)
  {
   bSemiAutomatic = False;

   PlaySwitch1();
   Pawn(Owner).ClientMessage("Fire Set To Auto");
   bAutomatic = True;
   return;
  }
 }
 
 if (bBurstFire)
 {
  if (bHasAuto)
  {
   bBurstFire = False;

   PlaySwitch1();
   Pawn(Owner).ClientMessage("Fire Set To Auto");
   bAutomatic = True;
   return;
  }
  bBurstFire = False;

  PlaySwitch2();
  Pawn(Owner).ClientMessage("Fire Set To Semi-Auto");
  bSemiAutomatic = True;
  return;
 }
}

simulated function PlaySelectiveFiring()
{
	local Pawn aPawn;
	local float rnd;
	local Name anim;
	local float FR;
	
	FR = ShotTime;
	if (FR < 0.05) ShotTime = 0.05;
	
	anim = 'Shoot';

	if (bHandToHand)
	{
		rnd = FRand();
		if (rnd < 0.33)
			anim = 'Attack';
		else if (rnd < 0.66)
			anim = 'Attack2';
		else
			anim = 'Attack3';
	}

	if (( Level.NetMode == NM_Standalone ) || ( DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn())) )
	{
		//if (bAutomatic)
			LoopAnim(anim, 0.598 / FR, 0.1);
		/*else
			PlayAnim(anim,2 / FR);*/
			//PlayAnim(anim,,0.1);
	}
	else if ( Role == ROLE_Authority )
	{
		for ( aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.nextPawn )
		{
			if ( aPawn.IsA('DeusExPlayer') && ( DeusExPlayer(Owner) != DeusExPlayer(aPawn) ) )
			{
				// If they can't see the weapon, don't bother
				if ( DeusExPlayer(aPawn).FastTrace( DeusExPlayer(aPawn).Location, Location ))
					DeusExPlayer(aPawn).ClientPlayAnimation( Self, anim, 0.1, bAutomatic );
			}
		}
	}
}

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 UpdateStats();
}

function TravelPostAccept()
{
 Super.TravelPostAccept();
 
 UpdateStats();
}

auto state Pickup
{
 function Frob(Actor A, Inventory B)
 {
  local DeusExPlayer P;
  local int i, j;
  
  if (A.Isa('DeusExPlayer'))
  {
   P = DeusExPlayer(A);
   
   if (!P.FindInventorySlotXY(invslotsx,invslotsy,i,j))
   {
    P.ClientMessage("You don't have enough room in your inventory to pick up the "$ItemName);
    return;
   }
  }
 
  Super.Frob(A, B);
 }
}

function GiveTo(Pawn A)
{
 Super.GiveTo(A);
 
 FixInvGrouping();
}

//fix the stuck up glitches around acquiring the same inv group twice.
function FixInvGrouping()
{
 local Byte B;
 local Weapon W;
 local int i, k;
 
  forEach AllActors(class'Weapon', W)
  {
   if (W != Self)
    k++;
  }
 
 do
 {
  forEach AllActors(class'Weapon', W)
  {
   
   if (B == W.InventoryGroup && W != Self)
   {
    B ++;
    i = 0;
    break;
   }
   
   if (W != Self)
    i++;
   
  }
 }
 until (i == k)
 
 InventoryGroup = B;
 //Default.InventoryGroup = B;
}

function bool HandlePickupQuery( inventory Item )
{
       if (item.class == self.class)
	return false;

       else
	return Super.HandlePickupQuery(Item);
}

function PlayFiringSound()
{
 if (AmmoName == Class'Ammo20mm') PlaySimSound( Sound'AssaultGunFire20mm', SLOT_None, TransientSoundVolume, 2048 );
}

function PlayNewFiringSound()
{
 if (bUsingSilencer && Accesory ~= "Silencer") PlaySimSound( SilencedFireSound, SLOT_None, TransientSoundVolume, 2048 );
 if (!bUsingSilencer || Accesory != "Silencer") PlaySimSound( CustomFireSound, SLOT_None, TransientSoundVolume, 2048 );
}

function PlayAfterFiringSound()
{
 if (AfterFireSound != None) PlaySimSound( AfterFireSound, SLOT_None, TransientSoundVolume, 2048 );
}

function PlayBreakSound()
{
 PlaySimSound( Sound'PartShatter', SLOT_None, TransientSoundVolume, 2048 );
}

function PlaySwitch1()
{
 PlaySimSound( Sound'WeaponFlick1', SLOT_None, TransientSoundVolume, 2048 );
 PlayAnim('Toggle');
}

function PlaySwitch2()
{
 PlaySimSound( Sound'WeaponFlick2', SLOT_None, TransientSoundVolume, 2048 );
 PlayAnim('Toggle');
}

function PlayJammingSound()
{
 Pawn(Owner).ClientMessage("|cf86500WEAPON JAM");
 EraseMuzzleFlashTexture();
 
 PlaySimSound( Sound'WeaponJam', SLOT_None, TransientSoundVolume, 2048 );
}

function ErrorDiagnostic()
{
 local string S;

	EraseMuzzleFlashTexture();

	Pawn(Owner).ClientMessage("|cf88000Weapon Diagnostic:");
	
	if (CurPinDurability <= 0) Pawn(Owner).ClientMessage("|p4Shattered Firing Pin");
	if (CurBarrelDurability <= 0) Pawn(Owner).ClientMessage("|p4Weathered Weapon Barrel");
	if (CurStockDurability <= 0) Pawn(Owner).ClientMessage("|p4Fractured Control Stock");
	if (CurBodyDurability <= 0) Pawn(Owner).ClientMessage("|p4Broken Weapon Body");
	if (CurFeedDurability <= 0) Pawn(Owner).ClientMessage("|p4Jamming Feed System");
	
}

function Fire(float Value)
{
 if (CurStockDurability <= 0)
 {
  RecoilStrength = Default.RecoilStrength + 0.5;
  RecoilMod = 5;
 }
 
 if (CurPinDurability <= 0 || CurBarrelDurability <= 0 || CurBodyDurability <= 0)
 {
  ErrorDiagnostic();

  GotoState('Idle');

  if (bHasMuzzleFlash)
   EraseMuzzleFlashTexture();
  
  NewFinish();
  
  return;
 }
 
 Super.Fire(Value);
}

state FinishFire
{
Begin:
        CurBurstFireCount = 0;
	bFiring = False;

	//if (bBurstFire) Sleep(PostBurstDelay);
	if (bBurstFire) Sleep(ShotTime);

	if ( bDestroyOnFinish )
		Destroy();
	else
		Finish();
}

state IdleFinish
{
	function bool PutDown()
	{
		// alert NPCs that I'm putting away my gun
		AIEndEvent('WeaponDrawn', EAITYPE_Visual);

		return Super.PutDown();
	}

	function AnimEnd()
	{
	}

	function Timer()
	{
		PlayIdleAnim();
	}

Begin:
        CurBurstFireCount = 0;
	bFiring = False;
	ReadyToFire();

	if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
	{
	}
	else
	{
		if (!bNearWall)
			PlayAnim('Idle1',,0.1);
		SetTimer(0.1, True);

	}

	if (bBurstFire || bSemiAutomatic) Sleep(ShotTime);

	if (bSemiAutomatic) EraseMuzzleFlashTexture();

	if ( bDestroyOnFinish )
		Destroy();
	else
		NewFinish();
}

function NewFinish()
{
	if ( Level.NetMode != NM_Standalone )
		ReadyClientToFire( True );
	
	if (bHasMuzzleFlash && !bSemiAutomatic)
		EraseMuzzleFlashTexture();

	if ( bChangeWeapon )
	{
		GotoState('DownWeapon');
		return;
	}

	if (( Level.NetMode != NM_Standalone ) && IsInState('Active'))
	{
		GotoState('Idle');
		return;
	}

	if (Pawn(Owner) == None)
	{
		GotoState('Idle');
		return;
	}
	if ( PlayerPawn(Owner) == None )
	{
		//bFireMem = false;
		//bAltFireMem = false;
		if ( ((AmmoType==None) || (AmmoType.AmmoAmount<=0)) && ReloadCount!=0 )
		{
			Pawn(Owner).StopFiring();
			Pawn(Owner).SwitchToBestWeapon();
		}
		else if ( (Pawn(Owner).bFire != 0) && (FRand() < RefireRate) )
			Global.Fire(0);
		else if ( (Pawn(Owner).bAltFire != 0) && (FRand() < AltRefireRate) )
			Global.AltFire(0);	
		else 
		{
			Pawn(Owner).StopFiring();
			GotoState('Idle');
		}
		return;
	}

	if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
	{
		GotoState('Idle');
		return;
	}

	if ( ((AmmoType==None) || (AmmoType.AmmoAmount<=0)) || (Pawn(Owner).Weapon != self) )
		GotoState('Idle');
	/*	else if ( /*bFireMem ||*/ Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( /*bAltFireMem ||*/ Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);	*/
	else 
		GotoState('Idle');
}

state Reload
{
ignores Fire, AltFire;

	function float GetReloadTime()
	{
		local float val;

		val = ReloadTime;

		if (ScriptedPawn(Owner) != None)
		{
			val = ReloadTime * (ScriptedPawn(Owner).BaseAccuracy*2+1);
		}
		else if (DeusExPlayer(Owner) != None)
		{
			// check for skill use if we are the player
			val = GetWeaponSkill();
			val = ReloadTime + (val*ReloadTime);
		}

		return val;
	}

	function NotifyOwner(bool bStart)
	{
		local DeusExPlayer player;
		local ScriptedPawn pawn;

		player = DeusExPlayer(Owner);
		pawn   = ScriptedPawn(Owner);

		if (player != None)
		{
			if (bStart)
				player.Reloading(self, GetReloadTime()+(1.0/AnimRate));
			else
			{
				player.DoneReloading(self);
			}
		}
		else if (pawn != None)
		{
			if (bStart)
				pawn.Reloading(self, GetReloadTime()+(1.0/AnimRate));
			else
				pawn.DoneReloading(self);
		}
	}

Begin:
	FinishAnim();

	// only reload if we have ammo left
	if (AmmoType.AmmoAmount > 0)
	{
		if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
		{
			ClientReload();
			Sleep(GetReloadTime());
			ReadyClientToFire( True );
		}
		else
		{
			bWasZoomed = bZoomed;
			if (bWasZoomed)
				ScopeOff();

			if (AmmoName != class'Ammo20mm') Owner.PlaySound(Reload1Sound, SLOT_None,,, 1024);		// CockingSound is reloadbegin
			if (AmmoName == class'Ammo20mm') Owner.PlaySound(Sound'M203Reload', SLOT_None,,, 1024);		// CockingSound is reloadbegin
			PlayAnim('ReloadBegin');
			NotifyOwner(True);
			FinishAnim();
			LoopAnim('Reload');
			Sleep(GetReloadTime());
			if (AmmoName != class'Ammo20mm') Owner.PlaySound(Reload2Sound, SLOT_None,,, 1024);		// AltFireSound is reloadend
			if (AmmoName == class'Ammo20mm') Owner.PlaySound(Sound'M203ReloadEnd', SLOT_None,,, 1024);		// AltFireSound is reloadend
			PlayAnim('ReloadEnd');
			FinishAnim();
			NotifyOwner(False);

			if (bWasZoomed)
				ScopeOn();

			ClipCount = 0;
			CurBurstFireCount = 0;
		}
	}
	GotoState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if (bAutomatic || CurBurstFireCount >= BurstFireCount)
		{
			CurBurstFireCount = 0;

					if (bBurstFire)
					{
						CurBurstFireCount = 0;
						//EraseMuzzleFlashTexture();
						GoToState('IdleFinish');
						return;
					}

			if ((Pawn(Owner).bFire != 0) && (AmmoType.AmmoAmount > 0))
			{
				if (PlayerPawn(Owner) != None)
					Global.Fire(0);
				else 
				{
					if (bBurstFire)
					{
						CurBurstFireCount = 0;
						//EraseMuzzleFlashTexture();
						GoToState('IdleFinish');
					}
					GotoState('FinishFire');
				}
			}
			else 
			{
				if (bBurstFire)
				{
					CurBurstFireCount = 0;
					//EraseMuzzleFlashTexture();
					GoToState('IdleFinish');
				}

				GotoState('FinishFire');
			}
		}
		else
		{
			// if we are a thrown weapon and we run out of ammo, destroy the weapon
			if (bHandToHand && (ReloadCount > 0) && (AmmoType.AmmoAmount <= 0))
				Destroy();
		}
	}
	function float GetShotTime()
	{
		local float mult, sTime;

		if (ScriptedPawn(Owner) != None)
			return ShotTime * (ScriptedPawn(Owner).BaseAccuracy*2+1);
		else
		{
			// AugCombat decreases shot time
			mult = 1.0;
			if (bHandToHand && DeusExPlayer(Owner) != None)
			{
				mult = 1.0 / DeusExPlayer(Owner).AugmentationSystem.GetAugLevelValue(class'AugCombat');
				if (mult == -1.0)
					mult = 1.0;
			}
			sTime = ShotTime * mult;
			return (sTime);
		}
	}

Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{

		/*if (!bAutomatic || (bBurstFire && CurBurstFireCount >= BurstFireCount))
		{
			CurBurstFireCount = 0;
			bFiring = False;

			if (bBurstFire) GoToState('IdleFinish');
			if (!bBurstFire) FinishAnim();
		}*/

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;

				// should we autoreload?
				if (DeusExPlayer(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					/*if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();*/

					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();			

					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	if (bSemiAutomatic)
	{
	 //EraseMuzzleFlashTexture();
	 SwapMuzzleFlashTexture();
	 //PlayNewFiringSound();
	 //SetTimer(0.1, False);
	 GoToState('IdleFinish');
	}
	if ( CurFeedDurability <= 0 && Frand() < 0.25)
	{
	 PlayJammingSound();
	 GoToState('IdleFinish');
	}

	if ( bAutomatic && (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient())))
		GotoState('Idle');

	//PlayNewFiringSound();

	if (bBurstFire) CurBurstFireCount++;

	Sleep(GetShotTime() / 2);
	//PlayAfterFiringSound();
	Sleep(GetShotTime() / 2);

	if (bAutomatic || CurBurstfireCount < BurstFireCount)
	{
		SwapMuzzleFlashTexture();
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}

	if (bBurstFire)
	{
		SwapMuzzleFlashTexture();
		CurBurstFireCount = 0;
		//EraseMuzzleFlashTexture();
		GoToState('IdleFinish');
	}

	bFiring = False;
	if (!bBurstFire) FinishAnim();

	// if ReloadCount is 0 and we're not hand to hand, then this is a
	// single-use weapon so destroy it after firing once
	if ((ReloadCount == 0) && !bHandToHand)
	{
		if (DeusExPlayer(Owner) != None)
			DeusExPlayer(Owner).RemoveItemFromSlot(Self);   // remove it from the inventory grid
		Destroy();
	}
	ReadyToFire();
Done:
	bFiring = False;

	if (bBurstFire)
	{
		SetTimer(0.1, True);
		GoToState('Idle');
	}

	Finish();
}

function GiveAmmo( Pawn Other )
{

	if ( AmmoName == None )
		return;
	AmmoType = Ammo(Other.FindInventoryType(AmmoName));
	if ( AmmoType != None && AmmoCombatRifle(AmmoType).Caliber ~= CaliberType)
		AmmoType.AddAmmo(PickUpAmmoCount);
	else
	{
		AmmoType = Spawn(AmmoName);	// Create ammo type required		
		Other.AddInventory(AmmoType);		// and add to player's inventory
		AmmoType.BecomeItem();
		AmmoType.AmmoAmount = PickUpAmmoCount; 
		AmmoType.GotoState('Idle2');

		AmmoType.SetPropertyText("NumProjectiles", "1");
		AmmoType.SetPropertyText("Caliber", String(CaliberType));
		AmmoType.SetPropertyText("Special", "None");
		AmmoType.SetPropertyText("CustomName", "Standard");
		AmmoCombatRifle(AmmoType).UpdateName();
	}
}	

simulated function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local Rotator rot;
	local actor Other;
	local float dist, alpha, degrade;
	local int i, numSlugs;
	local float volume, radius;
	local int NumProj;

	// make noise if we are not silenced
	if (!bUsingSilencer && !bHandToHand)
	{
		GetAIVolume(volume, radius);
		Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
		Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
		if (!Owner.IsA('PlayerPawn'))
			Owner.AISendEvent('Distress', EAITYPE_Audio, volume, radius);
	}

	PlayNewFiringSound();

	if (AmmoName != Class'Ammo20mm')
	{

        CurPinDurability -= 1; //firing pin
	CurBarrelDurability -= 1; // barrel
	CurStockDurability -= 1; //stock
	CurBodyDurability -= 1; //body
	CurFeedDurability -= 1; //feed system
	

	if (CurPinDurability < 0) CurPinDurability = 0;
	if (CurBarrelDurability < 0) CurBarrelDurability = 0;
	if (CurStockDurability < 0) CurStockDurability = 0;
	if (CurBodyDurability < 0) CurBodyDurability = 0;
	if (CurFeedDurability < 0) CurFeedDurability = 0;
	
	if (CurFeedDurability <= 0 && bHasFeed)
	{
	 bHasFeed = False;
	 ErrorDiagnostic();
	 PlayBreakSound();
	}
	if (CurStockDurability <= 0 && bHasStock)
	{
	 bHasStock = False;
	 ErrorDiagnostic();
	 PlayBreakSound();
	}
	if (CurPinDurability <= 0 || CurBarrelDurability <= 0 || CurBodyDurability <= 0)
	{
	 ErrorDiagnostic();
	 PlayBreakSound();	 
	 GoToState('Idle');
	}

	}
	if (Accesory ~= "GrenadeLauncher" && AmmoName == class'Ammo20mm')
	{
	 CurAccesoryDurability -= 10; //accesory
	 
	 if (CurAccesoryDurability <= 0)
	 {
	  PlayBreakSound();
	  CycleAmmo();
	  Pawn(Owner).ClientMessage("|cf88Grenade Launcher Has Worn Out.");
	  Accesory = "";
	  AccesoryName = "";
	 }
	}
	if (Accesory ~= "Silencer" && bUsingSilencer)
	{
	 CurAccesoryDurability -= 1; //accesory
	 
	 if (CurAccesoryDurability <= 0)
	 {
	  PlayBreakSound();
	  bUsingSilencer = False;
	  bHasSilencer = False;
	  Pawn(Owner).ClientMessage("|cf88Silencer Has Worn Out.");
	  Accesory = "";
	  AccesoryName = "";
	 }
	}
	if (Accesory ~= "LaserSight" && bLasing)
	{
	 CurAccesoryDurability -= 1; //accesory
	 
	 if (CurAccesoryDurability <= 0)
	 {
	  PlayBreakSound();
	  LaserOff();
	  Pawn(Owner).ClientMessage("|cf88Laser Sight Has Worn Out.");
	  Accesory = "";
	  AccesoryName = "";
	  bHasLaser = False;
	 }
	}
	if (Accesory ~= "Acog" && bZoomed)
	{
	 CurAccesoryDurability -= 1; //accesory
	 
	 if (CurAccesoryDurability <= 0)
	 {
	  PlayBreakSound();
	  ScopeOff();
	  Pawn(Owner).ClientMessage("|cf88000Acog Sight Has Worn Out.");
	  Accesory = "";
	  AccesoryName = "";
	  bHasScope = False;
	 }
	}
	
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = ComputeProjectileStart(X, Y, Z);
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);

	NumProj = int(AmmoType.GetPropertyText("NumProjectiles"));

	if (NumProj <= 0) NumProj = 1;

		numSlugs = NumProj;

	// if there is a scope, but the player isn't using it, decrease the accuracy
	// so there is an advantage to using the scope
	if (bHasScope && !bZoomed)
		Accuracy += 0.2;
	// if the laser sight is on, make this shot dead on
	// also, if the scope is on, zero the accuracy so the shake makes the shot inaccurate
	else if ((bLasing && Accesory ~= "LaserSight"))
		Accuracy /= 4;
	else if (bZoomed)
		Accuracy = 0.0;

	for (i=0; i<numSlugs; i++)
	{
      // If we have multiple slugs, then lower our accuracy a bit after the first slug so the slugs DON'T all go to the same place
      if ((i > 0) && (Level.NetMode != NM_Standalone) && !(bHandToHand))
         if (Accuracy < MinSpreadAcc)
            Accuracy = MinSpreadAcc;

      // Let handtohand weapons have a better swing
      if ((bHandToHand) && (NumSlugs > 1) && (Level.NetMode != NM_Standalone))
      {
         StartTrace = ComputeProjectileStart(X,Y,Z);
         StartTrace = StartTrace + (numSlugs/2 - i) * SwingOffset;
      }

      EndTrace = StartTrace + Accuracy * (FRand()-0.5)*Y*1000 + Accuracy * (FRand()-0.5)*Z*1000 ;
      EndTrace += (FMax(1024.0, MaxRange) * vector(AdjustedAim));
      
      Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

		// randomly draw a tracer for relevant ammo types
		// don't draw tracers if we're zoomed in with a scope - looks stupid
      // DEUS_EX AMSD In multiplayer, draw tracers all the time.
		if ( ((Level.NetMode == NM_Standalone) && (!bZoomed && (numSlugs == 1) && (FRand() < 0.5))) ||
           ((Level.NetMode != NM_Standalone) && (Role == ROLE_Authority) && (numSlugs == 1)) )
		{
			if (bTraceProj)
			{
				if (VSize(HitLocation - StartTrace) > 250)
				{
					rot = Rotator(EndTrace - StartTrace);
               if ((Level.NetMode != NM_Standalone) && (Self.IsA('WeaponRifle')))
                  Spawn(class'SniperTracer',,, StartTrace + 96 * Vector(rot), rot);
               else
                  Spawn(class'Tracer',,, StartTrace + 96 * Vector(rot), rot);
				}
			}
		}

		// check our range
		dist = Abs(VSize(HitLocation - Owner.Location));

		if (dist <= AccurateRange)		// we hit just fine
			ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		else if (dist <= MaxRange)
		{
			// simulate gravity by lowering the bullet's hit point
			// based on the owner's distance from the ground
			alpha = (dist - AccurateRange) / (MaxRange - AccurateRange);
			degrade = 0.5 * Square(alpha);
			HitLocation.Z += degrade * (Owner.Location.Z - Owner.CollisionHeight);
			ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		}
	}

	// otherwise we don't hit the target at all
 
}

simulated function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Vector Start, X, Y, Z;
	local DeusExProjectile proj;
	local float mult;
	local float volume, radius;
	local int i, NP;
	local Pawn aPawn;

	local int NumProj;

	if (Accesory ~= "GrenadeLauncher" && AmmoName == class'Ammo20mm')
	{
	 CurAccesoryDurability -= 10; //accesory
	 
	 if (CurAccesoryDurability <= 0)
	 {
	  PlayBreakSound();
	  CycleAmmo();
	  Pawn(Owner).ClientMessage("|cf88Grenade Launcher Has Worn Out.");
	  Accesory = "";
	 }
	}

	// AugCombat increases our speed (distance) if hand to hand
	mult = 1.0;
	if (bHandToHand && (DeusExPlayer(Owner) != None))
	{
		mult = DeusExPlayer(Owner).AugmentationSystem.GetAugLevelValue(class'AugCombat');
		if (mult == -1.0)
			mult = 1.0;
		ProjSpeed *= mult;
	}

	// skill also affects our damage
	// GetWeaponSkill returns 0.0 to -0.7 (max skill/aug)
	mult += -2.0 * GetWeaponSkill();

	// make noise if we are not silenced
	if (!bUsingSilencer && !bHandToHand)
	{
		GetAIVolume(volume, radius);
		Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
		Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
		if (!Owner.IsA('PlayerPawn'))
			Owner.AISendEvent('Distress', EAITYPE_Audio, volume, radius);
	}

	NumProj = int(AmmoType.GetPropertyText("NumProjectiles"));

	if (NumProj <= 0) NumProj = 1;

	NP = NumProj;

	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	Start = ComputeProjectileStart(X, Y, Z);

	for (i=0; i<NP; i++)
	{
      // If we have multiple slugs, then lower our accuracy a bit after the first slug so the slugs DON'T all go to the same place
      if ((i > 0) && (Level.NetMode != NM_Standalone))
         if (currentAccuracy < MinProjSpreadAcc)
            currentAccuracy = MinProjSpreadAcc;
         
		AdjustedAim = pawn(owner).AdjustAim(ProjSpeed, Start, AimError, True, bWarn);
		AdjustedAim.Yaw += currentAccuracy * (Rand(1024) - 512);
		AdjustedAim.Pitch += currentAccuracy * (Rand(1024) - 512);


		if (( Level.NetMode == NM_Standalone ) || ( Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient()) )
		{
			proj = DeusExProjectile(Spawn(ProjClass, Owner,, Start, AdjustedAim));
			if (proj != None)
			{
				// AugCombat increases our damage as well
				proj.Damage *= mult;

				// send the targetting information to the projectile
				if (bCanTrack && (LockTarget != None) && (LockMode == LOCK_Locked))
				{
					proj.Target = LockTarget;
					proj.bTracking = True;
				}
			}
		}
		else
		{
			if (( Role == ROLE_Authority ) || (DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn())) )
			{
				// Do it the old fashioned way if it can track, or if we are a projectile that we could pick up again
				if ( bCanTrack || Self.IsA('WeaponShuriken') || Self.IsA('WeaponMiniCrossbow') || Self.IsA('WeaponLAM') || Self.IsA('WeaponEMPGrenade') || Self.IsA('WeaponGasGrenade'))
				{
					if ( Role == ROLE_Authority )
					{
						proj = DeusExProjectile(Spawn(ProjClass, Owner,, Start, AdjustedAim));
						if (proj != None)
						{
							// AugCombat increases our damage as well
								proj.Damage *= mult;
							// send the targetting information to the projectile
							if (bCanTrack && (LockTarget != None) && (LockMode == LOCK_Locked))
							{
								proj.Target = LockTarget;
								proj.bTracking = True;
							}
						}
					}
				}
				else
				{
					proj = DeusExProjectile(Spawn(ProjClass, Owner,, Start, AdjustedAim));
					if (proj != None)
					{
						proj.RemoteRole = ROLE_None;
						// AugCombat increases our damage as well
						if ( Role == ROLE_Authority )
							proj.Damage *= mult;
						else
							proj.Damage = 0;
					}
					if ( Role == ROLE_Authority )
					{
						for ( aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.nextPawn )
						{
							if ( aPawn.IsA('DeusExPlayer') && ( DeusExPlayer(aPawn) != DeusExPlayer(Owner) ))
								DeusExPlayer(aPawn).ClientSpawnProjectile( ProjClass, Owner, Start, AdjustedAim );
						}
					}
				}
			}
		}

	}
	return proj;
}

function UpdateStats()
{
 local int R, R2, R3, R4, R5, R6, R7;
 local float Accuracy, TempAcc;
 local Sound S;
 
 //NumProj = SpreadTypes[SpreadType];
 
 if (AmmoName != class'Ammo20mm') ReloadCount = ClipMod;
 
 ReloadTime = Default.ReloadTime + ReloadMod;
 
 hitDamage = CaliberType / 100;
 //hitDamage = Default.hitDamage + DamageMod;
 
 BaseAccuracy = Default.BaseAccuracy - (0.1 * AccMod);
 
 ShotTime = Default.ShotTime + (1 * RateMod);
 
 Mass = Default.Mass + WeightMod;
 
 RecoilStrength = Default.RecoilStrength + (0.1 * RecoilMod);
 
 //This becomes an ammo-exploitable glitch thanks to break-down...
 //PickupAmmoCount = ReloadCount;
 PickupAmmoCount = 0;
 
 LowAmmoWaterMark = ReloadCount;
 
 UpdateName();
 
 SelectSound = Sound(DynamicLoadObject(CusSelect , class'Sound'));
 CustomFireSound = Sound(DynamicLoadObject(CusFire , class'Sound'));
 AfterFireSound = Sound(DynamicLoadObject(AftFire , class'Sound'));
 Reload1Sound = Sound(DynamicLoadObject(Reload1 , class'Sound'));
 Reload2Sound = Sound(DynamicLoadObject(Reload2 , class'Sound'));
 SilencedFireSound = Sound(DynamicLoadObject(SilenFire , class'Sound'));
 
 if (bTweakSkins)
 {
 Multiskins[0] = Texture(DynamicLoadObject(Multi0 , class'Texture'));
 Multiskins[1] = Texture(DynamicLoadObject(Multi1 , class'Texture'));
 Multiskins[4] = Texture(DynamicLoadObject(Multi4 , class'Texture'));
 Multiskins[5] = Texture(DynamicLoadObject(Multi5 , class'Texture'));
 Multiskins[6] = Texture(DynamicLoadObject(Multi6 , class'Texture'));
 }

 //PlayerViewMesh = Mesh(DynamicLoadObject(FirstMesh , class'Mesh'));
 PickupViewMesh = Mesh(DynamicLoadObject(PickupMesh , class'Mesh'));
 ThirdPersonMesh = Mesh(DynamicLoadObject(ThirdMesh , class'Mesh'));
}

simulated function ProcessTraceHit(Actor A, Vector H, Vector N, Vector X, Vector Y, Vector Z)
{
 ApplyVSBonus(A, H, N, X, Y, Z);
 ApplySpecialEffects(A, H, N, X, Y, Z);
 
 Super.ProcessTraceHit(A, H, N, X, Y, Z);
}

function ApplyVSBonus(Actor A, vector H, vector N, vector X, vector Y, vector Z)
{
 if (A != None)
 {
  if (A.IsA('Pawn'))
  {
   if (AmmoCombatRifle(AmmoType).VSBonus ~= "Armored" && (  Pawn(A).Default.Health >= 150 || Pawn(A).Default.HealthTorso >= 125 || Pawn(A).Default.HealthHead >= 125 || Pawn(A).IsA('Robot') ) )
   {
    A.TakeDamage(hitDamage, Pawn(Owner), H, N, 'Sabot');
   }
   if (AmmoCombatRifle(AmmoType).VSBonus ~= "Unarmored" && (  Pawn(A).Default.Health < 150 || Pawn(A).Default.HealthTorso < 125 || Pawn(A).Default.HealthHead < 125  ) && !Pawn(A).IsA('Robot') )
   {
    A.TakeDamage(hitDamage, Pawn(Owner), H, N, 'Shot');
   }
   if (AmmoCombatRifle(AmmoType).VSBonus ~= "Organic")
   {
    if (!Pawn(A).IsA('Robot') )
    {
     A.TakeDamage(hitDamage, Pawn(Owner), H, N, 'Poison');
    }
    //Spawn(class'AcidSplash',,,H);
   }
  }
  if (A.IsA('DeusExDecoration'))
  {
   if (AmmoCombatRifle(AmmoType).VSBonus ~= "Armored" && DeusExDecoration(A).MinDamageThreshold >= 10)
   {
    A.TakeDamage(hitDamage, Pawn(Owner), H, N, 'Sabot');
   }
   if (AmmoCombatRifle(AmmoType).VSBonus ~= "Unarmored" && DeusExDecoration(A).MinDamageThreshold < 10)
   {
    A.TakeDamage(hitDamage, Pawn(Owner), H, N, 'Shot');
   }
  }
 }
}

function ApplySpecialEffects(Actor A, vector H, vector N, vector X, vector Y, vector Z)
{
 if (A != None)
 {
  //MAJOR NERF; incendiary doesnt always proc.
  if (AmmoCombatRifle(AmmoType).Special ~= "Fire" && Frand() < 0.2)
  {
   A.TakeDamage(hitDamage / 2, Pawn(Owner), H, N, 'Flamed');
   Spawn(class'FireSplash',,,H);
  }
  if (AmmoCombatRifle(AmmoType).Special ~= "Explosive")
  {
   A.TakeDamage(hitDamage / 2, Pawn(Owner), H, N, 'Exploded');
   Spawn(class'BlastSplash',,,H);
   HurtRadius(hitDamage, 40, 'Exploded', 1, H);
  }
  if (AmmoCombatRifle(AmmoType).Special ~= "EMP")
  {
   A.TakeDamage(hitDamage * 4, Pawn(Owner), H, N, 'EMP');
   Spawn(class'ShockSplash',,,H);
   HurtRadius(hitDamage, 24, 'EMP', 1, H);
  }
  if (AmmoCombatRifle(AmmoType).VSBonus ~= "Organic")
  {
   Spawn(class'AcidSplash',,,H);
  }
 }
}

function name WeaponDamageType()
{
 return 'Shot';
}

function Vector TraceErrHitLocation()
{
 local actor Act;
 local Vector v1, v2;
 local Vector Pos;
 local Rotator r1, r2;
 
 Pos = Owner.Location;
 Pos.Z += Pawn(Owner).BaseEyeHeight;
 
 r1 = (Rot(1,0,0) * Rand(128) * 16 * PosNeg()) + (Rot(0,1,0) * Rand(128) * 16 * PosNeg());
 r2 = Pawn(Owner).ViewRotation + r1;
 
 Act = Trace(v1, v2, Pos + (vect(16384,0,0)) >> r2, Pos, True);
 																	
 return v1;
}

function int PosNeg()
{
 local int r;
 
 r = Rand(2);
 
 if (r == 0) return -1;
 if (r == 1) return 1;
}

function Vector TraceHitLocation()
{
 local actor Act;
 local Vector v1, v2;
 local Vector Pos;
 
 Pos = Owner.Location;
 Pos.Z += Pawn(Owner).BaseEyeHeight;
 
 Act = Trace(v1, v2, Pos + (vect(16384,0,0) >> Pawn(Owner).ViewRotation), Pos, True);
 
 return v1;
}

function string GetFiringMode()
{
 if (bSemiAutomatic) return "Semi;";
 if (bBurstFire) return "BurstFire;";
 if (bAutomatic) return "Auto;";
 
 return "Auto;";
}

simulated function bool UpdateInfo(Object winObject)
{
	local PersonaInventoryInfoWindow winInfo;
	local string str;
	local int i, dmg;
	local float mod;
	local bool bHasAmmo;
	local bool bAmmoAvailable;
	local class<DeusExAmmo> ammoClass;
	local Pawn P;
	local Ammo weaponAmmo;
	local int  ammoAmount;
        local int LOLWUT; //why did nobody tell us number of shots in our spread before now?!?
	local string elementcolor;

	P = Pawn(Owner);
	if (P == None)
		return False;

	winInfo = PersonaInventoryInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.SetTitle(itemName);
	winInfo.SetText(msgInfoWeaponStats);
	winInfo.AddLine();

	// stats

	winInfo.AddInfoItem("Barrel:" , CurBarrelDurability$"/"$BarrelDurability);
	winInfo.AddInfoItem("Pin:" , CurPinDurability$"/"$PinDurability);
	winInfo.AddInfoItem("Feed:" , CurFeedDurability$"/"$FeedDurability);
	winInfo.AddInfoItem("Body:" , CurBodyDurability$"/"$BodyDurability);
	winInfo.AddInfoItem("Stock:" , CurStockDurability$"/"$StockDurability);

	winInfo.AddLine();

	winInfo.AddInfoItem("Damage:" , FormatFloatString(hitDamage, 1.0));

	winInfo.AddInfoItem("Fire Rate:", GetFiringMode()@FormatFloatString(1.0/ShotTime, 0.1) @ msgInfoRoundsPerSec);

	winInfo.AddInfoItem("Accuracy:" , String(  Int((2.0 - BaseAccuracy)*50.0)  ) $ "%");

	winInfo.AddInfoItem("Recoil:" , String(5 + RecoilMod));

	winInfo.AddInfoItem("Caliber:" , FormatFloatString(  float(CaliberType) / 100, 0.01  )$"mm");

	winInfo.AddInfoItem("Capacity:" , String(ReloadCount)@"RNDS");

	winInfo.AddInfoItem("Accessory:" , GetAccesoryType()$";"@CurAccesoryDurability$"/"$AccesoryDurability);

	winInfo.AddInfoItem("Weight:" , FormatFloatString(Mass, 1.0) @ msgMassUnit);
	
	str = FormatFloatString(ReloadTime, 0.1) @ msgTimeUnit;

	winInfo.AddInfoItem("Reload Time:", str);	
	
	winInfo.AddLine();
	//winInfo.SetText(Description);

	return True;
}

function UpdateName()
{
 ItemName = CustomColor$FormatFloatString(float(CaliberType) / 100, 0.01)$"mm"@CustomName;
 
 BeltDescription = CustomColor$CAPS(StripVowels(CustomName));
 
 AmmoCombatRifle(AmmoType).UpdateName();
 
 DeusExPlayer(Owner).UpdateBeltText(Self); //fix caliber naming.
}

function string StripVowels(String s)
{
 local string S2;
 
 S2 = s;
 
 return S2;
}

// Become a pickup
// Weapons that carry their ammo with them don't vanish when dropped
function BecomePickup()
{
	Super.BecomePickup();
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 0.0;
}

defaultproperties
{
     AmmoNames(0)=class'AmmoCombatRifle'
     AmmoNames(1)=class'Ammo20mm'
     ProjectileNames(1)=class'Custom20mmShell'
     bHasMuzzleFlash=True
     LowAmmoWaterMark=30
     GoverningSkill=None
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     bAutomatic=True
     ShotTime=0.100000
     reloadTime=2.500000
     HitDamage=5
     BaseAccuracy=0.500000
     recoilStrength=0.500000
     MinWeaponAcc=0.200000
     AmmoName=Class'MSMassEffect.AmmoCombatRifle'
     ReloadCount=30
     PickupAmmoCount=30
     bInstantHit=True
     FireOffset=(X=-16.000000,Y=5.000000,Z=11.500000)
     shakemag=200.000000
     FireSound=Sound'DeusExSounds.Weapons.AssaultGunFire'
     AltFireSound=Sound'DeusExSounds.Weapons.AssaultGunReloadEnd'
     CockingSound=Sound'DeusExSounds.Weapons.AssaultGunReload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultGunSelect'
     InventoryGroup=4
     ItemName="Assault Rifle"
     ItemArticle="a"
     PlayerViewOffset=(X=16.000000,Y=-5.000000,Z=-11.500000)
     PlayerViewMesh=LODMesh'DeusExItems.AssaultGun'
     ;PLAYERVIEWMESH=LodMesh'MSMASSEFFECT.AK471stMag'
     PICKUPVIEWMESH=LODMesh'MSMassEffect.AK47PickupMag'
     ThirdPersonMesh=LodMesh'MSMassEffect.AK473rdMag'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconAssaultGun'
     largeIcon=Texture'DeusExUI.Icons.LargeIconAssaultGun'
     largeIconWidth=94
     largeIconHeight=65
     invSlotsX=2
     invSlotsY=2
     Description="The 7.62x51mm assault rifle is designed for close-quarters combat, utilizing a shortened barrel and 'bullpup' design for increased maneuverability. An additional underhand 20mm HE launcher increases the rifle's effectiveness against a variety of targets."
     beltDescription="ASSAULT"
     Mesh=LodMesh'AK47PickupMag'
     CollisionRadius=20.000000
     CollisionHeight=1.100000
     Mass=25.000000
     SilencedFireSound=Sound'SilencedRifleFire'
     CustomFireSound=Sound'RifleFire1'
     ClipMod=40
     bHasAuto=True
     BurstFireCount=3
     CaliberType=556
     SilencedFireSound=Sound'SilencedRifleFire'
     SilenFire="MSMassEffect.SilencedRifleFire"
     ScopeFOV=25
     LoadHax(0)=LODMesh'AK47PickupDrum'
     LoadHax(1)=LODMesh'AK473rdDrum'
     LoadHax(2)=LODMesh'AK471stDrum'
     Texture=Texture'ReflectionMapTex2'
     bTweakSkins=False
}
